/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.tmodel.TModel;

public class WSTModel {
    private WSUDDIRegistry m_uddiRegistry = null;
    private String m_tModelKey = null;
    private TModel m_tModel = null;
    private CategoryBag m_categoryBag = null;
    private Vector m_categoryVector = null;
    private IdentifierBag m_identifierBag = null;
    private Vector m_identifierVector = null;

    public WSTModel(WSUDDIRegistry uddiRegistry, TModel tModel) {
        this.m_uddiRegistry = uddiRegistry;
        this.m_tModel = tModel;
    }

    public WSTModel(WSUDDIRegistry uddiRegistry, String tModelKey) {
        this.m_uddiRegistry = uddiRegistry;
        this.m_tModelKey = tModelKey;
    }

    public String getTModelKey() {
        if (this.m_tModel != null) {
            return this.m_tModel.getTModelKey();
        }
        return null;
    }

    public String getName() {
        if (this.m_tModel != null) {
            return this.m_tModel.getName();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public String getAuthorizedName() {
        if (this.m_tModel != null) {
            return this.m_tModel.getAuthorizedName();
        }
        return null;
    }

    public String getDescription() {
        Vector v;
        if (this.m_tModel != null && (v = this.m_tModel.getDescriptionVector()) != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
            return ((Description)v.get(0)).getValue();
        }
        return null;
    }

    public Vector getCategories() throws Exception {
        if (this.m_categoryVector == null && this.m_categoryBag == null && this.m_tModel != null) {
            this.m_categoryBag = this.m_tModel.getCategoryBag();
            if (this.m_categoryBag != null) {
                this.m_categoryVector = this.m_categoryBag.getKeyedReferenceVector();
            }
        }
        return this.m_categoryVector;
    }

    public Vector getIdentifiers() throws Exception {
        if (this.m_identifierVector == null && this.m_identifierBag == null && this.m_tModel != null) {
            this.m_identifierBag = this.m_tModel.getIdentifierBag();
            if (this.m_identifierBag != null) {
                this.m_identifierVector = this.m_identifierBag.getKeyedReferenceVector();
            }
        }
        return this.m_identifierVector;
    }

    public String getOverviewDocDescription() {
        Vector v;
        OverviewDoc overviewDoc;
        if (this.m_tModel != null && (overviewDoc = this.m_tModel.getOverviewDoc()) != null && (v = overviewDoc.getDescriptionVector()) != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
            return ((Description)v.get(0)).getValue();
        }
        return null;
    }

    public String getOverviewDocURL() {
        OverviewDoc overviewDoc;
        if (this.m_tModel != null && (overviewDoc = this.m_tModel.getOverviewDoc()) != null) {
            return overviewDoc.getOverviewURLString();
        }
        return null;
    }
}

